/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.DummyExternalServerHelper;
import it.actalis.ellips.capi.provider.ExternalServerHelper;
import it.actalis.vol.utils.Constants;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class ExternalServerToken
extends TokenSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String TOKEN_RS = "ExternServerToken";
    private ExternalServerHelper b = new DummyExternalServerHelper();

    private static String a(String[] stringArray, int n) {
        if (stringArray.length >= n + 1 && stringArray[n] != null) {
            return stringArray[n];
        }
        return null;
    }

    @Override
    public void initializeLib(String[] stringArray) throws CapiException {
        ExternalServerToken externalServerToken = this;
        externalServerToken.initProviders(externalServerToken);
    }

    @Override
    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        a.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(stringArray);
    }

    @Override
    public void finalizeLib() {
        try {
            this.closeSession();
            return;
        }
        catch (CapiException capiException) {
            a.debug("Error closing session: " + capiException.getMessage());
            return;
        }
    }

    @Override
    public String[] getLibInfo() {
        String string = "External Server Token";
        String string2 = "";
        String string3 = "Ellips Remote Signature Token";
        String string4 = "1.0";
        String string5 = "Actalis S.p.A.";
        String string6 = "";
        String string7 = "Actalis S.p.A.";
        String string8 = "";
        String string9 = "Actalis S.p.A.";
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9};
    }

    @Override
    public String getLibName() {
        return null;
    }

    @Override
    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    @Override
    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public String getSerialNumber() throws CapiException {
        return "0";
    }

    @Override
    public long getFreeSpace() throws CapiException {
        return -1L;
    }

    @Override
    public void changePIN(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    @Override
    public void changePUK(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    @Override
    public long getMaxRSAKeyLength() throws CapiException {
        return 2048L;
    }

    @Override
    public long getMinRSAKeyLength() throws CapiException {
        return 768L;
    }

    @Override
    public void unblockPIN(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    @Override
    public long getMaxPINLen() throws CapiException {
        return 100L;
    }

    @Override
    public long getMinPINLen() throws CapiException {
        return 0L;
    }

    @Override
    public void openSession(boolean bl, String string) throws CapiException {
        this.b.openSession(bl, string);
    }

    @Override
    public void openSession(boolean bl, String string, int n) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    @Override
    public void openSessionAuthPath(boolean bl) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    @Override
    public void openPublicSession() throws CapiException {
    }

    @Override
    public void closeSession() throws CapiException {
        this.b.closeSession();
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        return this.b.isSessionOpen();
    }

    @Override
    public byte[] getData(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    @Override
    public void setData(String string, byte[] byArray, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    @Override
    public String getCert(String string) throws CapiException {
        return this.b.getCert(string);
    }

    @Override
    public void setCert(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    @Override
    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    @Override
    public boolean canImport() {
        return false;
    }

    @Override
    public boolean canExport(String string) {
        return false;
    }

    @Override
    public int canUnblock() {
        return 0;
    }

    @Override
    public void genKeyPair(String string, int n, int n2, int n3) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public void genKeyPair(String string, KeyAlgo keyAlgo, int n, int n2, int n3) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public String impCred(String string, PrivateKey privateKey, int n, int n2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    @Override
    public PrivateKey expCred(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    @Override
    public PublicKey getPublicKey(String string) throws CapiException {
        return this.b.getPublicKey(string);
    }

    @Override
    public PrivateKey getPrivateKey(String object) throws CapiException {
        Object object2 = this.getCert((String)object);
        if (object2 != null) {
            object2 = new Certificate(Base64.decode((String)object2));
            object = new Actalis_PrivateKey((String)object);
            ((Actalis_PrivateKey)object).setPublicInfo((RSAPublicKey)((Certificate)object2).getInternalCert().getPublicKey());
            ((Actalis_PrivateKey)object).setCryptoDev(this);
            return object;
        }
        return null;
    }

    @Override
    public void instCert(String string, Certificate certificate, boolean bl, boolean bl2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    @Override
    public int getKeyUsage(String string, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public int getKeyLength(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public byte[] doSign(byte[] byArray, String string, int n) throws CapiException {
        return this.b.doSign(byArray, string, n);
    }

    @Override
    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    @Override
    public String[] listObjects(String string, byte by) throws CapiException {
        return this.b.listObjects(string, by);
    }

    @Override
    public void deleteObject(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public byte getObjectType(String string) throws CapiException {
        return 2;
    }

    @Override
    public String getObjectID(String string) throws CapiException {
        return string;
    }

    @Override
    public int getObjectSize(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void renameObject(String string, String string2, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void setCert(String string, Certificate certificate, int n, byte[] byArray, boolean bl) throws CapiException {
    }

    @Override
    public void setCkaId(String string, String string2, byte[] byArray) throws CapiException {
    }

    @Override
    public boolean exist(String string) throws CapiException {
        return this.b.exist(string);
    }

    @Override
    public String generateID(String[] stringArray) {
        return ExternalServerToken.a(stringArray, 2) + "@" + ExternalServerToken.a(stringArray, 3);
    }

    public ExternalServerHelper getCurrent_helper() {
        return this.b;
    }

    public void setCurrent_helper(ExternalServerHelper externalServerHelper) {
        this.b = externalServerHelper;
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (x500Name == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), publicKey.getEncoded());
            publicKey = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature signature = Signature.getInstance("SHA1withRSA", ActalisSingleton.getActalisProvider());
        signature.initSign(privateKey);
        try {
            signature.update(publicKey.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + exception);
        }
        x500Name = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        x500Name = new CertificationRequest((CertificationRequestInfo)x500Name, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(signature.sign()));
        return x500Name;
    }

    @Override
    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        ExternalServerToken externalServerToken = this;
        externalServerToken.initProviders(externalServerToken);
    }

    @Override
    public boolean requiredExtendedAuth() {
        return false;
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        return this.certReq(x500Name, publicKey, privateKey, Security.getProvider(string));
    }

    @Override
    public String certReq(String string, X500Name x500Name) throws CapiException {
        return this.certReq(x500Name, this.getPublicKey(string), this.getPrivateKey(string), ProvUtils.actalisProvider);
    }

    @Override
    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String string2) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name object, PublicKey object2, PrivateKey privateKey, Provider provider) throws CapiException {
        try {
            a.debug("creating and signing certreq...");
            a.debug("subject: " + object.toString());
            try {
                object = new JcaPKCS10CertificationRequestBuilder(object, (PublicKey)object2);
                object = object.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build(privateKey));
            }
            catch (Exception exception) {
                object = exception;
                throw exception;
            }
            a.debug("certRequest ok");
        }
        catch (IllegalStateException illegalStateException) {
            a.debug(illegalStateException.getMessage(), (Throwable)illegalStateException);
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            object2 = new StringWriter();
            privateKey = new PEMWriter((Writer)object2);
            privateKey.writeObject(object);
            privateKey.close();
            object = new String(((StringWriter)object2).getBuffer());
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception saving PEM certificate Requet", 1003);
        }
    }

    @Override
    public void resetToken(String string) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

