/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.tsl.ParsingResults;
import it.actalis.ellips.capi.tsl.rootupdater.TSLInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;

public class RootUpdaterReport {
    private HashMap<String, TSLInfo> a = new HashMap();

    public void addTSLInfo(TSLInfo tSLInfo) {
        this.a.put(tSLInfo.getNationalId(), tSLInfo);
    }

    public TSLInfo getTSLInfoByNationalID(String string) {
        Object object = this.a.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (!((TSLInfo)(object2 = this.a.get(object2))).getNationalId().equalsIgnoreCase(string)) continue;
            return object2;
        }
        return null;
    }

    public ArrayList<TSLInfo> getAllTSLInfo() {
        ArrayList<TSLInfo> arrayList = new ArrayList<TSLInfo>();
        Object object = this.a.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            object2 = this.a.get(object2);
            arrayList.add((TSLInfo)object2);
        }
        return arrayList;
    }

    public void reset() {
        this.a.clear();
    }

    public boolean isOverAllOK() {
        Object object = this.a.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (((TSLInfo)(object2 = this.a.get(object2))).isParsed()) continue;
            return false;
        }
        return true;
    }

    public int countNotParsed() {
        int n = 0;
        Object object = this.a.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (((TSLInfo)(object2 = this.a.get(object2))).isParsed()) continue;
            ++n;
        }
        return n;
    }

    public ArrayList<TSLInfo> getNotParsed() {
        ArrayList<TSLInfo> arrayList = new ArrayList<TSLInfo>();
        Object object = this.a.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (((TSLInfo)(object2 = this.a.get(object2))).isParsed()) continue;
            arrayList.add((TSLInfo)object2);
        }
        return arrayList;
    }

    public void toFile(File file) throws IOException {
        file.delete();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.a.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            CertDBItem certDBItem;
            int n;
            Object object2 = (String)object.next();
            if (((TSLInfo)(object2 = this.a.get(object2))).getParsingResults() == null) continue;
            arrayList.add(String.format("TSL: %s (%s)", ((TSLInfo)object2).getNationalId(), ((TSLInfo)object2).getUrl()));
            arrayList.add(String.format("\tProviders: %d", ((TSLInfo)object2).getParsingResults().nProviders));
            arrayList.add(String.format("\tServices: %d", ((TSLInfo)object2).getParsingResults().nServices));
            arrayList.add(String.format("\t\tTrusted: %d", ((TSLInfo)object2).getParsingResults().nServiceTrusted));
            arrayList.add(String.format("\t\tWarning: %d", ((TSLInfo)object2).getParsingResults().nServiceWarning));
            arrayList.add(String.format("\t\tUntrusted: %d", ((TSLInfo)object2).getParsingResults().nServiceUntrusted));
            arrayList.add(String.format("\t\tRemoved: %d", ((TSLInfo)object2).getParsingResults().nServiceRemoved));
            arrayList.add(String.format("\tCertificate: %d", ((TSLInfo)object2).getParsingResults().nTotalCerts));
            arrayList.add(String.format("\t\tImported: %d", ((TSLInfo)object2).getParsingResults().nCertImported));
            arrayList.add(String.format("\t\tImported Skipped: %d", ((TSLInfo)object2).getParsingResults().nCertImportSkipped));
            arrayList.add(String.format("\t\tImported CAIssuer: %d", ((TSLInfo)object2).getParsingResults().nCertImportedByCAIssuer));
            arrayList.add(String.format("\t\tUpdated: %d", ((TSLInfo)object2).getParsingResults().nCertUpdated));
            arrayList.add(String.format("\t\tUpdated Skipped: %d", ((TSLInfo)object2).getParsingResults().nCertUpdateSkipped));
            arrayList.add(String.format("\t\tRemoved: %d", ((TSLInfo)object2).getParsingResults().nCertRemoved));
            arrayList.add(String.format("\t\tRemoved Skipped: %d", ((TSLInfo)object2).getParsingResults().nCertRemoveSkipped));
            arrayList.add(String.format("\t\tErrors: %d", ((TSLInfo)object2).getParsingResults().nCertErrors));
            arrayList.add("");
            arrayList.add(String.format("\tTRUSTED roots: %d", ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).size()));
            for (n = 0; n < ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).size(); ++n) {
                certDBItem = ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).get(n);
                arrayList.add(String.format("\t\tName: %s", certDBItem.getName()));
                arrayList.add(String.format("\t\tSubject: %s", certDBItem.getSubject()));
                arrayList.add(String.format("\t\tIssuer: %s", certDBItem.getIssuer()));
                arrayList.add(String.format("\t\tSource: %s", certDBItem.getSourceAsString()));
                arrayList.add(String.format("\t\tEllipsUsage: %s", certDBItem.getEllipsUsages().toString()));
                arrayList.add("\t\t-------------------");
            }
            arrayList.add(String.format("\tWARNING roots: %d", ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).size()));
            for (n = 0; n < ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).size(); ++n) {
                certDBItem = ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).get(n);
                arrayList.add(String.format("\t\tName: %s", certDBItem.getName()));
                arrayList.add(String.format("\t\tSubject: %s", certDBItem.getSubject()));
                arrayList.add(String.format("\t\tIssuer: %s", certDBItem.getIssuer()));
                arrayList.add(String.format("\t\tSource: %s", certDBItem.getSourceAsString()));
                arrayList.add(String.format("\t\tEllipsUsage: %s", certDBItem.getEllipsUsages().toString()));
                arrayList.add("\t\t-------------------");
            }
            arrayList.add(String.format("\tUNTRUSTED roots: %d", ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).size()));
            for (n = 0; n < ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).size(); ++n) {
                certDBItem = ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).get(n);
                arrayList.add(String.format("\t\tName: %s", certDBItem.getName()));
                arrayList.add(String.format("\t\tSubject: %s", certDBItem.getSubject()));
                arrayList.add(String.format("\t\tIssuer: %s", certDBItem.getIssuer()));
                arrayList.add(String.format("\t\tSource: %s", certDBItem.getSourceAsString()));
                arrayList.add(String.format("\t\tEllipsUsage: %s", certDBItem.getEllipsUsages().toString()));
                arrayList.add("\t\t-------------------");
            }
            arrayList.add(String.format("\tREMOVED roots: %d", ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).size()));
            for (n = 0; n < ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).size(); ++n) {
                certDBItem = ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).get(n);
                arrayList.add(String.format("\t\tName: %s", certDBItem.getName()));
                arrayList.add(String.format("\t\tSubject: %s", certDBItem.getSubject()));
                arrayList.add(String.format("\t\tIssuer: %s", certDBItem.getIssuer()));
                arrayList.add(String.format("\t\tSource: %s", certDBItem.getSourceAsString()));
                arrayList.add(String.format("\t\tEllipsUsage: %s", certDBItem.getEllipsUsages().toString()));
                arrayList.add("\t\t-------------------");
            }
            arrayList.add(String.format("\tCAISSUER roots: %d", ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).size()));
            for (n = 0; n < ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).size(); ++n) {
                certDBItem = ((TSLInfo)object2).getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).get(n);
                arrayList.add(String.format("\t\tName: %s", certDBItem.getName()));
                arrayList.add(String.format("\t\tSubject: %s", certDBItem.getSubject()));
                arrayList.add(String.format("\t\tIssuer: %s", certDBItem.getIssuer()));
                arrayList.add(String.format("\t\tSource: %s", certDBItem.getSourceAsString()));
                arrayList.add(String.format("\t\tEllipsUsage: %s", certDBItem.getEllipsUsages().toString()));
                arrayList.add("\t\t-------------------");
            }
            arrayList.add("\n-----------------------------------------\n");
        }
        Files.write(file.toPath(), arrayList, Charset.forName("UTF-8"), new OpenOption[0]);
    }
}

