/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.arubapec.ca.pkcs11.card.AtrType;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardStore;
import java.io.IOException;

public class Atr {
    private AtrType type = AtrType.COMPLETE;
    private String value;
    private String cardFamilyName;
    private transient CardFamily cardFamily = null;

    public Atr(AtrType atrType, String string, CardFamily cardFamily) {
        this.type = atrType;
        this.value = string;
        this.cardFamily = cardFamily;
        this.cardFamilyName = cardFamily.getName();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public AtrType getType() {
        return this.type;
    }

    public void setType(AtrType atrType) {
        this.type = atrType;
    }

    public CardFamily getCardFamily() {
        return this.cardFamily;
    }

    public void setCardFamily(CardFamily cardFamily) {
        this.cardFamily = cardFamily;
        this.cardFamilyName = cardFamily.getName();
    }

    void rebuild(CardStore object) throws IOException {
        if (this.cardFamily == null) {
            for (CardFamily cardFamily : ((CardStore)object).getCardFamilies()) {
                if (this.cardFamilyName == null || !this.cardFamilyName.equals(cardFamily.getName())) continue;
                this.cardFamily = cardFamily;
                break;
            }
        }
        if (this.cardFamily == null) {
            throw new IOException("No family found for this ATR --> " + this.cardFamilyName);
        }
    }

    public boolean equals(Atr atr) {
        if (!atr.getCardFamily().equals(this.cardFamily)) {
            return false;
        }
        if (!atr.getType().equals((Object)this.type)) {
            return false;
        }
        return atr.getValue().equals(this.value);
    }
}

