/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.pades;

import esecurity.validator.bean.PadesSpecific;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.SignedData;

public class PadesCMSSignedDataCheck {
    public static ValidatorMessage check(PadesSpecific padesSpecific, SignatureInformation signatureInformation, ValidationContextParameters validationContextParameters) {
        if (padesSpecific.isMultipleSigners()) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0013_FORMAT_PADES_NOTVALID_CMSMULTISIGNERS, new Object[0]);
        }
        if (signatureInformation.getPadesSpecific().getSubFilter().equalsIgnoreCase("ETSI.CAdES.detached")) {
            padesSpecific = signatureInformation.getSignerInfoData().getSignerInfo().getUnauthenticatedAttributes();
            signatureInformation = signatureInformation.getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
            if (padesSpecific != null && signatureInformation == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0015_FORMAT_PADES_NOTVALID_MISSINGSIGNEDATTRS, new Object[0]);
            }
            if (signatureInformation != null) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                for (int i = 0; i < signatureInformation.size(); ++i) {
                    String string = signatureInformation.getObjectAt(i) instanceof DERSequence ? ((DERSequence)signatureInformation.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)signatureInformation.getObjectAt(i)).getObjectAt(0).toString();
                    if (string.equals(CMSAttributes.messageDigest.getId())) {
                        bl = true;
                        continue;
                    }
                    if (string.equals(CMSAttributes.contentType.getId())) {
                        bl2 = true;
                        continue;
                    }
                    if (string.equals(CMSAttributes.signingTime.getId())) continue;
                    if (string.equals(SignedData.id_aa_signingCertificate.getId())) {
                        bl3 = true;
                        continue;
                    }
                    if (string.equals(SignedData.id_aa_signingCertificateV2.getId())) {
                        bl4 = true;
                        continue;
                    }
                    if (string.equals(SignedData.pkcs_9_at_counterSignature.getId())) {
                        bl5 = true;
                        continue;
                    }
                    if (string.equals(SignedData.id_aa_contentReference.getId())) {
                        bl6 = true;
                        continue;
                    }
                    if (string.equals(SignedData.id_aa_contentIdentifier.getId())) {
                        bl7 = true;
                        continue;
                    }
                    if (string.equals(SignedData.id_aa_contentHint.getId())) {
                        bl8 = true;
                        continue;
                    }
                    if (string.equals(SignedData.id_aa_ets_commitmentType.getId())) {
                        bl9 = true;
                        continue;
                    }
                    if (!string.equals(SignedData.id_aa_ets_signerLocation.getId())) continue;
                    bl10 = true;
                }
                if (!bl2 || !bl || !bl3 && !bl4) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0015_FORMAT_PADES_NOTVALID_MISSINGSIGNEDATTRS, new Object[0]);
                }
                if (bl5 || bl6 || bl7 || bl8 || validationContextParameters.getSignature().getPadesSpecific().getReason() != null && bl9 || bl10) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0016_FORMAT_PADES_NOTVALID_UNESPECTEDSIGNEDATTRS, new Object[0]);
                }
            }
        }
        return null;
    }
}

