/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl.sqllite;

import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.tsl.sqllite.SqlDbManifest;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class DefaultManifestSignatureValidator
implements ManifestValidator {
    private final CertDb db;

    public DefaultManifestSignatureValidator(CertDb certDb) {
        this.db = certDb;
    }

    @Override
    public boolean verify(SqlDbManifest sqlDbManifest) throws CapiException {
        byte[] byArray = sqlDbManifest.getSigner();
        Certificate certificate = new Certificate(byArray);
        if (!this.isValidSigner(certificate)) {
            throw new CapiException("Invalid Signer: Error verifying certificate chain", 50010);
        }
        if (!certificate.isElectronicSeal()) {
            throw new CapiException("Invalid Signer: Certificate is not valid for electronic seal", 50010);
        }
        Object object = certificate.getSubjectOrganization();
        if (object == null || ((String[])object).length == 0 || !"Aruba PEC S.p.A.".equals(object[0])) {
            throw new CapiException("Invalid Signer: Organization not recognized", 50010);
        }
        try {
            object = Signature.getInstance("SHA256withRSA");
            ((Signature)object).initVerify(certificate.getPublicKey());
            for (String string : sqlDbManifest.getEntries().keySet()) {
                ((Signature)object).update(string.getBytes());
                byte[] object2 = sqlDbManifest.getEntries().get(string);
                ((Signature)object).update(object2);
            }
            ((Signature)object).update(byArray);
            return ((Signature)object).verify(sqlDbManifest.getSignature());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new CapiException("Invalid Signature", 3010, generalSecurityException);
        }
    }

    @Override
    public boolean isValidSigner(Certificate object) {
        object = this.db.retrieveCertificateChain((Certificate)object);
        return ((CertChain)object).overAllOk();
    }
}

