/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.dts.TimeStampToken;
import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import java.util.LinkedList;

public class TimeStampStepSignatureDPCM45DigestAlgoCheck
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureDPCM45DigestAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        if (validationContextParameters.getSignature() == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        object = validationContextParameters.getSignature().getSignerInfoData();
        if (object == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0008_TIMESTAMP_NOSHA256, this.getClass().getName());
        }
        if (((SignerInfoData)object).getDigestAlgo().equals(DigestAlgorithm.SHA256.getId()) || ((SignerInfoData)object).getDigestAlgo().equals(DigestAlgorithm.SHA512.getId())) {
            try {
                object = new TimeStampToken(validationContextParameters.getSignature().getSignatureInfo());
            }
            catch (CapiException capiException) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, this.getClass().getName());
            }
            try {
                if (((TimeStampToken)object).getSigningCertificateV2HashAlg() != null && ((TimeStampToken)object).getSigningCertificateV2HashAlg().equals(DigestAlgorithm.SHA256.getId()) && ((TimeStampToken)object).getInternalTst().getTimeStampInfo().getMessageImprintAlgOID().getId() != null && ((TimeStampToken)object).getInternalTst().getTimeStampInfo().getMessageImprintAlgOID().getId().equals(DigestAlgorithm.SHA256.getId())) {
                    return null;
                }
            }
            catch (CapiException capiException) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, this.getClass().getName());
            }
            catch (Exception exception) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
        }
        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0008_TIMESTAMP_NOSHA256, this.getClass().getName());
    }
}

