/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATRHashtable
extends Dictionary
implements Serializable,
Cloneable,
Map {
    private transient c[] a;
    private transient int b;
    private int c;
    private float d;
    private transient int e = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private volatile transient Set f = null;
    private volatile transient Set g = null;
    private volatile transient Collection h = null;
    private static a i = new a();

    public ATRHashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.d = f;
        this.a = new c[n];
        this.c = (int)((float)n * f);
    }

    public ATRHashtable(int n) {
        this(n, 0.75f);
    }

    public ATRHashtable() {
        this(11, 0.75f);
    }

    public ATRHashtable(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    public synchronized int size() {
        return this.b;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.b == 0;
    }

    public synchronized Enumeration keys() {
        return this.a(0);
    }

    public synchronized Enumeration elements() {
        return this.a(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        c[] cArray = this.a;
        int n = this.a.length;
        while (n-- > 0) {
            c c2 = cArray[n];
            while (c2 != null) {
                if (c2.c.equals(object)) {
                    return true;
                }
                c2 = c2.d;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        Object object2 = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % ((c[])object2).length;
        object2 = object2[n2];
        while (object2 != null) {
            if (object2.a == n && object2.b.equals(object)) {
                return true;
            }
            object2 = object2.d;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        Object object2 = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % ((c[])object2).length;
        object2 = object2[n2];
        while (object2 != null) {
            if (object2.a == n && object2.b.equals(object)) {
                return object2.c;
            }
            object2 = object2.d;
        }
        return null;
    }

    public synchronized Object getMatching(String string) {
        if (string == null) {
            return null;
        }
        c[] cArray = this.a;
        int n = this.a.length;
        while (n-- > 0) {
            c c2 = cArray[n];
            while (c2 != null) {
                Object object = Pattern.compile((String)c2.b, 2);
                if (((Matcher)(object = ((Pattern)object).matcher(string))).matches()) {
                    return c2.c;
                }
                c2 = c2.d;
            }
        }
        return null;
    }

    protected void rehash() {
        int n = this.a.length;
        c[] cArray = this.a;
        int n2 = (n << 1) + 1;
        c[] cArray2 = new c[n2];
        ++this.e;
        this.c = (int)((float)n2 * this.d);
        this.a = cArray2;
        while (n-- > 0) {
            c c2 = cArray[n];
            while (c2 != null) {
                c c3 = c2;
                c2 = c2.d;
                int n3 = (c3.a & Integer.MAX_VALUE) % n2;
                c3.d = cArray2[n3];
                cArray2[n3] = c3;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        c[] cArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % cArray.length;
        c c2 = cArray[n2];
        while (c2 != null) {
            if (c2.a == n && c2.b.equals(object)) {
                object = c2.c;
                c2.c = object2;
                return object;
            }
            c2 = c2.d;
        }
        ++this.e;
        if (this.b >= this.c) {
            this.rehash();
            cArray = this.a;
            n2 = (n & Integer.MAX_VALUE) % cArray.length;
        }
        cArray[n2] = c2 = new c(n, object, object2, cArray[n2]);
        ++this.b;
        return null;
    }

    public synchronized Object remove(Object object) {
        c[] cArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % cArray.length;
        c c2 = cArray[n2];
        c c3 = null;
        while (c2 != null) {
            if (c2.a == n && c2.b.equals(object)) {
                ++this.e;
                if (c3 != null) {
                    c3.d = c2.d;
                } else {
                    cArray[n2] = c2.d;
                }
                --this.b;
                object = c2.c;
                c2.c = null;
                return object;
            }
            c3 = c2;
            c2 = c2.d;
        }
        return null;
    }

    public synchronized void putAll(Map object) {
        for (Map.Entry entry : object.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        c[] cArray = this.a;
        ++this.e;
        int n = cArray.length;
        while (--n >= 0) {
            cArray[n] = null;
        }
        this.b = 0;
    }

    public synchronized Object clone() {
        try {
            ATRHashtable aTRHashtable = (ATRHashtable)super.clone();
            ((ATRHashtable)super.clone()).a = new c[this.a.length];
            int n = this.a.length;
            while (n-- > 0) {
                aTRHashtable.a[n] = this.a[n] != null ? (c)this.a[n].clone() : null;
            }
            aTRHashtable.f = null;
            aTRHashtable.g = null;
            aTRHashtable.h = null;
            aTRHashtable.e = 0;
            return aTRHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            entry = entry.getValue();
            stringBuffer.append((k == this ? "(this Map)" : k) + "=" + (entry == this ? "(this Map)" : entry));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private Enumeration a(int n) {
        if (this.b == 0) {
            return i;
        }
        return new d(this, n, false);
    }

    @Override
    public synchronized int hashCode() {
        int n = 0;
        if (this.b == 0 || this.d < 0.0f) {
            return 0;
        }
        this.d = -this.d;
        c[] cArray = this.a;
        for (int i = 0; i < cArray.length; ++i) {
            c c2 = cArray[i];
            while (c2 != null) {
                n += c2.b.hashCode() ^ c2.c.hashCode();
                c2 = c2.d;
            }
        }
        this.d = -this.d;
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.a.length);
        objectOutputStream.writeInt(this.b);
        for (int i = this.a.length - 1; i >= 0; --i) {
            c c2 = this.a[i];
            while (c2 != null) {
                objectOutputStream.writeObject(c2.b);
                objectOutputStream.writeObject(c2.c);
                c2 = c2.d;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.d) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.a = new c[n3];
        this.b = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    public Set keySet() {
        return null;
    }

    public Collection values() {
        return null;
    }

    public Set entrySet() {
        return null;
    }

    static {
        new b();
    }

    static final class b
    implements Iterator {
        b() {
        }

        @Override
        public final boolean hasNext() {
            return false;
        }

        public final Object next() {
            throw new NoSuchElementException("Hashtable Iterator");
        }

        @Override
        public final void remove() {
            throw new IllegalStateException("Hashtable Iterator");
        }
    }

    static final class a
    implements Enumeration {
        a() {
        }

        @Override
        public final boolean hasMoreElements() {
            return false;
        }

        public final Object nextElement() {
            throw new NoSuchElementException("Hashtable Enumerator");
        }
    }

    final class d
    implements Enumeration,
    Iterator {
        private c[] a;
        private int b;
        private c c;
        private c d;
        private int e;
        private boolean f;
        private int g;
        private /* synthetic */ ATRHashtable h;

        d(ATRHashtable aTRHashtable, int n, boolean bl) {
            this.h = aTRHashtable;
            this.a = this.h.a;
            this.b = this.a.length;
            this.c = null;
            this.d = null;
            this.g = this.h.e;
            this.e = n;
            this.f = false;
        }

        @Override
        public final boolean hasMoreElements() {
            c c2 = this.c;
            int n = this.b;
            c[] cArray = this.a;
            while (c2 == null && n > 0) {
                c2 = cArray[--n];
            }
            this.c = c2;
            this.b = n;
            return c2 != null;
        }

        public final Object nextElement() {
            c c2 = this.c;
            int n = this.b;
            c[] cArray = this.a;
            while (c2 == null && n > 0) {
                c2 = cArray[--n];
            }
            this.c = c2;
            this.b = n;
            if (c2 != null) {
                c2 = this.d = this.c;
                this.c = c2.d;
                if (this.e == 0) {
                    return c2.b;
                }
                if (this.e == 1) {
                    return c2.c;
                }
                return c2;
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public final boolean hasNext() {
            return this.hasMoreElements();
        }

        public final Object next() {
            if (this.h.e != this.g) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public final void remove() {
            if (!this.f) {
                throw new UnsupportedOperationException();
            }
            if (this.d == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (this.h.e != this.g) {
                throw new ConcurrentModificationException();
            }
            ATRHashtable aTRHashtable = this.h;
            synchronized (aTRHashtable) {
                c[] cArray = this.h.a;
                int n = (this.d.a & Integer.MAX_VALUE) % cArray.length;
                c c2 = cArray[n];
                c c3 = null;
                while (c2 != null) {
                    if (c2 == this.d) {
                        this.h.e++;
                        ++this.g;
                        if (c3 == null) {
                            cArray[n] = c2.d;
                        } else {
                            c3.d = c2.d;
                        }
                        this.h.b--;
                        this.d = null;
                        return;
                    }
                    c3 = c2;
                    c2 = c2.d;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    static final class c
    implements Map.Entry {
        int a;
        Object b;
        Object c;
        c d;

        protected c(int n, Object object, Object object2, c c2) {
            this.a = n;
            this.b = object;
            this.c = object2;
            this.d = c2;
        }

        protected final Object clone() {
            return new c(this.a, this.b, this.c, this.d == null ? null : (c)this.d.clone());
        }

        public final Object getKey() {
            return this.b;
        }

        public final Object getValue() {
            return this.c;
        }

        public final Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.c;
            this.c = object;
            return object2;
        }

        @Override
        public final boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            return (this.b == null ? object.getKey() == null : this.b.equals(object.getKey())) && (this.c == null ? object.getValue() == null : this.c.equals(object.getValue()));
        }

        @Override
        public final int hashCode() {
            return this.a ^ (this.c == null ? 0 : this.c.hashCode());
        }

        public final String toString() {
            return this.b.toString() + "=" + this.c.toString();
        }
    }
}

