/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.tsl.AtrDbItem;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.sqllite.ArubaCdbManifestValidator;
import esecurity.tsl.sqllite.ManifestSigner;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.tsl.sqllite.SqlLiteCdb;
import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.HttpRequest;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestClientRequest;
import it.actalis.ellips.capi.http.arubautils.rest.RestResponse;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsl.TSL;
import it.actalis.ellips.capi.tsl.TSLStatus;
import it.actalis.ellips.capi.tsl.rootupdater.ATSLUpdater;
import it.actalis.ellips.capi.tsl.rootupdater.CaTokensElement;
import it.actalis.ellips.capi.tsl.rootupdater.CaTokensResponse;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdaterGUI;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdaterReport;
import it.actalis.ellips.capi.tsl.rootupdater.TSLCache;
import it.actalis.ellips.capi.tsl.rootupdater.TSLDownloader;
import it.actalis.ellips.capi.tsl.rootupdater.TSLUpdater;
import it.actalis.ellips.capi.tsl.rootupdater.TSLUtils;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateMode;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateReportFileWriter;
import it.actalis.ellips.capi.tsl.rootupdater.UpdaterProgress;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyStore;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class RootUpdater {
    protected String homeFolder = null;
    protected static Logger logger = null;
    protected CertDb cdb = null;
    protected CertDB oldFormatCdb = null;
    protected String cdbName = null;
    protected File cdbFile = null;
    protected String cdbPassword = null;
    protected String customTSLItaUrl = "";
    protected String customTSLItaCert = "";
    protected String reportFileName = "";
    protected String mergeFileName = "";
    protected File indexLastUpdFile = null;
    protected File lastUpdFile = null;
    protected File progressFile = null;
    protected File reportFile = null;
    protected File mergeFile = null;
    protected File tslEndPointFile = null;
    protected final String DEBUG_CDB_NAME = "cert_debug.cdb";
    protected TSLDownloader tslDownloader = null;
    protected boolean forcedUpdate = false;
    protected boolean fileProgressEnabled = false;
    protected boolean printTSLEndpoints = false;
    protected boolean checkAdditionalSrvInfo = false;
    protected RootUpdaterReport report = null;
    protected RootUpdaterGUI updaterGUI = null;
    protected UpdateMode updateMode = UpdateMode.ATSL;
    protected final int UPD_DONE = 0;
    protected final int UPD_ERROR = 1;
    protected final int UPD_SKIP = 2;
    protected final int UPD_UNKNOWN = 3;
    protected final int UPD_IGNORED = 4;
    protected final int UPD_ARCHIVED = 5;
    protected List<String> ignoreTSL = new LinkedList<String>();
    protected List<String> ignoreVerificationTSL = new LinkedList<String>();
    protected String debugTSL = "";
    protected ManifestSigner signer;
    protected NetworkConfig networkConfig;
    private UpdateReportFileWriter a;
    private TSLCache b;
    private static ManifestValidator c;
    private KeyStore d;
    private String e;
    private List<CaTokensElement> f = new ArrayList<CaTokensElement>();
    private List<CaTokensElement> g = new ArrayList<CaTokensElement>();

    public static void setDefaultManifestValidator(ManifestValidator manifestValidator) {
        c = manifestValidator;
    }

    public RootUpdater(String string, String string2) throws CapiException {
        this(string, string2, "1234567890AAbbCCdd", null);
    }

    public RootUpdater(String string, String string2, String string3) throws CapiException {
        this(string, string2, string3, null);
    }

    public RootUpdater(String string, String string2, String string3, NetworkConfig networkConfig) throws CapiException {
        this(string, string2, string3, networkConfig, null);
    }

    public RootUpdater(String string, String string2, String string3, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this(string, "TSL", string2, string3, networkConfig, logger);
    }

    public RootUpdater(String string, String string2, String string3, String string4, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this(string, string2, string3, string4, null, networkConfig, logger);
    }

    public RootUpdater(String string, String string2, File file, String string3, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this(string, "TSL", string2, string3, file, networkConfig, logger);
    }

    public RootUpdater(String string, String string2, String string3, String string4, File file, NetworkConfig networkConfig, Logger logger) throws CapiException {
        this.a(string, string2, string3, string4, networkConfig, logger, file);
    }

    public RootUpdater(String string, String string2, String string3, String string4, File file, NetworkConfig networkConfig, Logger logger, ManifestSigner manifestSigner, KeyStore keyStore, String string5) throws CapiException {
        this.signer = manifestSigner;
        this.d = keyStore;
        this.e = string5;
        this.a(string, string2, string3, string4, networkConfig, logger, file);
    }

    public RootUpdater(String string, ValidatorConfig validatorConfig) throws CapiException {
        this(string, validatorConfig, null);
    }

    public RootUpdater(String string, ValidatorConfig validatorConfig, Logger logger) throws CapiException {
        this(string, validatorConfig, logger, null, null, null);
    }

    public RootUpdater(String string, ValidatorConfig object, Logger logger, ManifestSigner manifestSigner, KeyStore keyStore, String string2) throws CapiException {
        if (object == null) {
            throw new CapiException("No config specified", 1003);
        }
        this.signer = manifestSigner;
        manifestSigner = ((ValidatorConfig)object).getNetConfiguration();
        Object object2 = ((ConfigFile)object).getElement("certdb.file");
        object2 = new File((String)object2);
        object = ((ConfigFile)object).getElement("certdb.pwd");
        this.d = keyStore;
        this.e = string2;
        this.a(string, "", ((File)object2).getName(), (String)object, (NetworkConfig)manifestSigner, logger, null);
    }

    private void a(String object, String string, String string2, String string3, NetworkConfig networkConfig, Logger logger, File file) throws CapiException {
        this.homeFolder = object;
        this.cdbName = string2;
        this.cdbPassword = string3;
        this.a();
        RootUpdater.logger = logger == null ? EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME) : logger;
        this.a = new UpdateReportFileWriter(RootUpdater.logger);
        this.b = new TSLCache();
        if (networkConfig == null) {
            networkConfig = new NetworkConfig(RootUpdater.logger, false);
        }
        this.networkConfig = networkConfig;
        this.tslDownloader = new TSLDownloader(this.networkConfig, RootUpdater.logger);
        this.report = new RootUpdaterReport();
        if (!Util.isNullOrEmpty(string)) {
            this.homeFolder = (String)object + File.separator + string;
        }
        object = this.b();
        this.a((File)object);
        if (c == null) {
            c = new ArubaCdbManifestValidator();
        }
        this.b(file);
    }

    private void a() throws CapiException {
        if (Util.isNullOrEmpty(this.homeFolder)) {
            throw new CapiException("TSL home folder wrong or not specified", 1003);
        }
        if (Util.isNullOrEmpty(this.cdbName)) {
            throw new CapiException("cdb name wrong or not specified", 1003);
        }
    }

    private File b() throws CapiException {
        File file = new File(this.homeFolder);
        try {
            if (!file.exists()) {
                file.mkdirs();
                logger.info("TSL folder created");
            }
        }
        catch (SecurityException securityException) {
            logger.error("Unable to create TSL folder: " + securityException.getMessage());
            throw new CapiException("Unable to create TSL folder", 1003, securityException);
        }
        return file;
    }

    private void a(File file) {
        this.cdbFile = new File(file + File.separator + this.cdbName);
        this.indexLastUpdFile = new File(file + File.separator + "lastUpdIndex.ini");
        this.lastUpdFile = new File(file + File.separator + "atslLastUpd.txt");
        this.progressFile = new File(file + File.separator + "progress.txt");
        this.tslEndPointFile = new File(file + File.separator + "tslEndPoints.txt");
    }

    private void b(File file) throws CapiException {
        try {
            if (this.cdbFile.exists()) {
                try {
                    logger.info("Load cdb");
                    this.c();
                    return;
                }
                catch (Throwable throwable) {
                    logger.info("Error loading cdb, try with old format");
                    this.d();
                    return;
                }
            }
            if (file != null && file.exists()) {
                logger.info("Load default cdb");
                logger.info("Using cdb {}. Its size is {} KB", (Object)file.getAbsolutePath(), (Object)(file.length() / 1024L));
                Utils.copyFile(file, this.cdbFile);
                this.c();
                logger.info("Default cdb is copied to cdb folder");
                return;
            }
            logger.info("Create empty cdb");
            this.cdbFile.createNewFile();
            this.c();
            return;
        }
        catch (IOException iOException) {
            throw new CapiException("Error loading cdb file", 1003, iOException);
        }
        catch (Exception exception) {
            throw new CapiException("General cdb file error", 1003, exception);
        }
    }

    private void c() throws IOException {
        this.cdb = CertDbBuilder.get().setType(CertDbType.SQLLITE).setFile(this.cdbFile).setManifestValidator(c).setNetworkConfig(this.networkConfig).build();
    }

    private void d() throws IOException, CapiException {
        if (Util.isNullOrEmpty(this.cdbPassword)) {
            throw new CapiException("cdb password wrong or not specified", 1003);
        }
        File file = new File(this.cdbFile.getAbsolutePath() + ".old");
        Utils.copyFile(this.cdbFile, file, true);
        Files.deleteIfExists(this.cdbFile.toPath());
        this.oldFormatCdb = CertDB.getInstance(file.getAbsolutePath(), this.cdbPassword, false, true);
        this.c();
    }

    public void setReportFileName(String string) {
        this.reportFileName = string;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setMergeDiffFileName(String string) {
        this.mergeFileName = string;
    }

    public String getMergeDiffFileName() {
        return this.mergeFileName;
    }

    public String getTSLHistoryFolder() {
        return this.b.getCacheFolder();
    }

    public void setTSLHistoryFolder(String string) {
        this.b.setCacheFolder(string);
    }

    public void setForcedUpdate(boolean bl) {
        this.forcedUpdate = bl;
    }

    public boolean isForcedUpdate() {
        return this.forcedUpdate;
    }

    public void setForceHTTPSConnections(boolean bl) {
        if (this.tslDownloader != null) {
            this.tslDownloader.setForceHttps(bl);
        }
    }

    public boolean isCheckAdditionalSrvInfo() {
        return this.checkAdditionalSrvInfo;
    }

    public void setCheckAdditionalSrvInfo(boolean bl) {
        this.checkAdditionalSrvInfo = bl;
    }

    public boolean isForcedToHTTPSConnections() {
        if (this.tslDownloader != null) {
            return this.tslDownloader.isForceHttps();
        }
        return false;
    }

    public void setUntrustedStates(String[] stringArray) throws CapiException {
        if (this.tslDownloader == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setUntrustedStates(stringArray);
    }

    public void setTrustedStates(String[] stringArray) throws CapiException {
        if (this.tslDownloader == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setTrustedStates(stringArray);
    }

    public void setWarningStates(String[] stringArray) throws CapiException {
        if (this.tslDownloader == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setWarningStates(stringArray);
    }

    public void setRemoveStates(String[] stringArray) throws CapiException {
        if (this.tslDownloader == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setRemoveStates(stringArray);
    }

    public String getTSLUrlDSIta() {
        return TSL.URL_DSList.getUrl();
    }

    public void setTSLUrlDSIta(String string) {
        TSL.URL_DSList.setUrl(string);
    }

    public String getTSLUrlEU() {
        return TSL.URL_ListOfList.getUrl();
    }

    public void setTSLUrlEU(String string) {
        TSL.URL_ListOfList.setUrl(string);
    }

    public void setConnectionTimeout(int n) {
        this.tslDownloader.setReadTimeout(n);
        this.tslDownloader.setConnectionTimeout(n);
    }

    public void enableFileProgress() {
        this.fileProgressEnabled = true;
    }

    public void disableFileProgress() {
        this.fileProgressEnabled = false;
    }

    public boolean isProgressEnabled() {
        return this.fileProgressEnabled;
    }

    public File getProgressFile() {
        return this.progressFile;
    }

    public boolean isUpdateNeeded() {
        if (this.isRebuildFromScratchNeeded()) {
            return true;
        }
        switch (this.updateMode) {
            case TSL: {
                return this.isTSLUpdated(TSL.URL_DSList.getUrl()) || this.isTSLUpdated(TSL.URL_ListOfList.getUrl());
            }
            case ATSL: {
                return this.isTSLUpdated(ATSLUpdater.a);
            }
            case DEBUG: {
                return true;
            }
        }
        return false;
    }

    protected boolean isRebuildFromScratchNeeded() {
        if (!this.cdbFile.exists()) {
            logger.info("no cdb file found in " + this.cdbFile.getAbsolutePath() + ". It will be rebuilt from scratch");
            return true;
        }
        if (this.cdb.getServiceCount() == 0) {
            logger.info("cdb is empty. It will be rebuilt from scratch");
            return true;
        }
        if (this.updateMode.equals((Object)UpdateMode.TSL)) {
            if (!this.indexLastUpdFile.exists()) {
                logger.info("no index file found. Cdb will be rebuilt from scratch");
                return true;
            }
            return false;
        }
        if (this.updateMode.equals((Object)UpdateMode.ATSL) && !this.lastUpdFile.exists()) {
            logger.info("no update file found. Cdb will be downloaded");
            return true;
        }
        return false;
    }

    public CertDb getCertificateDB() {
        return this.cdb;
    }

    public void setGUI(RootUpdaterGUI rootUpdaterGUI) {
        this.updaterGUI = rootUpdaterGUI;
    }

    public boolean doUpdate() {
        Object object;
        RootUpdater rootUpdater;
        long l = System.currentTimeMillis();
        if (!this.reportFileName.isEmpty()) {
            rootUpdater = this;
            this.reportFile = new File(rootUpdater.homeFolder + File.separator + rootUpdater.reportFileName);
            rootUpdater.a.setFile(rootUpdater.reportFile);
            object = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            ((DateFormat)object).setTimeZone(Constants.DEFAULT_TIMEZONE);
            rootUpdater.a.write("--- TSL Update Report - " + ((DateFormat)object).format(new Date()));
            rootUpdater.a.write("--- -----------------");
            rootUpdater.a.write("mode: " + rootUpdater.updateMode.name());
            if (rootUpdater.updateMode == UpdateMode.TSL) {
                rootUpdater.a.write("Italian TSL DS URL: " + TSL.URL_DSList.getUrl());
                rootUpdater.a.write("European TSL URL: " + TSL.URL_ListOfList.getUrl());
                if (!rootUpdater.customTSLItaUrl.isEmpty()) {
                    rootUpdater.a.write("Italian Custom TSL DS URL: " + rootUpdater.customTSLItaUrl);
                }
            } else {
                rootUpdater.a.write("Aruba TSL URL: " + ATSLUpdater.a);
            }
            rootUpdater.a.write("Force using https url: " + rootUpdater.tslDownloader.isForceHttps());
            rootUpdater.a.write("Progress enabled: " + rootUpdater.isProgressEnabled());
            rootUpdater.a.write("Forced update: " + rootUpdater.isForcedUpdate());
            rootUpdater.a.write("--- -----------------");
        }
        if (!this.mergeFileName.isEmpty()) {
            this.mergeFile = new File(this.homeFolder + File.separator + this.mergeFileName);
            if (this.mergeFile.exists()) {
                this.mergeFile.delete();
            }
        }
        UpdaterProgress updaterProgress = UpdaterProgress.Builder().setFileProgressEnabled(this.fileProgressEnabled).setProgressFile(this.progressFile).setUpdaterGUI(this.updaterGUI).build();
        if (UpdateMode.TSL.equals((Object)this.updateMode)) {
            this.downloadAtrLists();
        }
        if (!this.isUpdateNeeded() && !this.isAtrListsUpdated()) {
            updaterProgress.update(1.0, "done", "");
            logger.debug("TSL update not required");
            this.a.write("No update done because not required");
            this.a.write("\n--- END");
            return true;
        }
        if (this.updaterGUI != null) {
            this.updaterGUI.updateTitle("CA root certificate update");
            this.updaterGUI.showGUI();
            updaterProgress.update(0.0, "initialization...", "");
        }
        logger.debug("TSL update started");
        try {
            boolean bl;
            object = updaterProgress;
            rootUpdater = this;
            if (rootUpdater.updateMode == UpdateMode.ATSL) {
                bl = ATSLUpdater.a().setLastUpdFile(rootUpdater.lastUpdFile).setCdb(rootUpdater.cdb).setCdbFile(rootUpdater.cdbFile).setManifestValidator(c).setOldFormatCdb(rootUpdater.oldFormatCdb).setNetworkConfig(rootUpdater.networkConfig).setProgress((UpdaterProgress)object).setReportWriter(rootUpdater.a).build().b();
            } else if (rootUpdater.updateMode == UpdateMode.TSL) {
                rootUpdater.updateATR();
                bl = new TSLUpdater.TSLUpdaterBuilder(0).setCdb(rootUpdater.cdb).setIgnoreTSL(rootUpdater.ignoreTSL).setIgnoreVerificationTSL(rootUpdater.ignoreVerificationTSL).setManifestSigner(rootUpdater.signer).setOldFormatCdb(rootUpdater.oldFormatCdb).setProgress((UpdaterProgress)object).setReportWriter(rootUpdater.a).setTslCache(rootUpdater.b).setTslDownloader(rootUpdater.tslDownloader).setIndexLastUpdFile(rootUpdater.indexLastUpdFile).setDebugTSL(rootUpdater.debugTSL).build().a();
            } else {
                bl = rootUpdater.updateMode == UpdateMode.DEBUG ? rootUpdater.e() : false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (CapiException capiException) {
            logger.error("error updating cdb: " + capiException.getMessage() + " code " + capiException.getErrorCode(), (Throwable)capiException);
            this.a.write("Error --- " + capiException.getMessage());
            return false;
        }
        catch (Throwable throwable) {
            logger.error("error updating cdb: " + throwable.getMessage(), throwable);
            this.a.write("Error --- " + throwable.getMessage());
            return false;
        }
        finally {
            this.a.write("\nTotal Root In DB : " + this.cdb.getServiceCount());
            long l2 = System.currentTimeMillis() - l;
            this.a.write("\nTotal elapsed time: " + l2 / 1000L + " sec");
            this.a.write("--- END ---");
            updaterProgress.update(1.0, "update finished", "");
            updaterProgress.close();
        }
    }

    private boolean e() throws CapiException, IOException {
        File file;
        block6: {
            file = null;
            try {
                file = new File(this.homeFolder + File.separator + "cert_debug.cdb");
                this.a.write("USING LOCAL CDB: " + file.getAbsolutePath());
                if (file.exists()) break block6;
                file.delete();
            }
            catch (Throwable throwable) {
                if (file != null) {
                    file.delete();
                }
                throw throwable;
            }
            return false;
        }
        Object object = CertDbBuilder.get().setType(CertDbType.SQLLITE).setFile(file).setNetworkConfig(this.networkConfig).setManifestValidator(c).build();
        File file2 = file;
        CertDb certDb = object;
        object = this;
        if (((RootUpdater)object).cdb == null) {
            Utils.copyFile(file2, ((RootUpdater)object).cdbFile, true);
        } else {
            ((SqlLiteCdb)((RootUpdater)object).cdb).merge(certDb);
        }
        ((RootUpdater)object).a.write("Update done");
        file.delete();
        return true;
    }

    public RootUpdaterReport getReport() {
        return this.report;
    }

    public void setIgnoreTSLList(List<String> list) {
        this.ignoreTSL.clear();
        for (int i = 0; i < list.size(); ++i) {
            String string = RootUpdater.a(list.get(i).toLowerCase());
            this.ignoreTSL.add(string);
        }
    }

    public void setIgnoreVerificationTSLList(List<String> list) {
        this.ignoreVerificationTSL.clear();
        for (int i = 0; i < list.size(); ++i) {
            String string = RootUpdater.a(list.get(i).toLowerCase());
            this.ignoreVerificationTSL.add(string);
        }
    }

    public String getCertDBFilePath() {
        return this.cdbFile.getAbsolutePath();
    }

    public void useCustomTSLDSIta(String string, String string2) {
        this.customTSLItaUrl = string;
        this.customTSLItaCert = string2;
    }

    private static String a(String string) {
        return string.replace("http://", "").replace("https://", "");
    }

    public boolean isPrintTSLEndPoints() {
        return this.printTSLEndpoints;
    }

    public void setPrintTSLEndPoints(boolean bl) {
        this.printTSLEndpoints = bl;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    protected boolean isTSLUpdated(String string) {
        if (this.forcedUpdate) {
            return true;
        }
        Date date = new Date(this.cdbFile.lastModified());
        Date date2 = TSLUtils.getLastTSLModifiedDate(string, this.tslDownloader.getNetworkConfig(), logger);
        if (date2 != null && !date2.after(date)) {
            logger.info("{}  not modified", (Object)string);
            return false;
        }
        return true;
    }

    public String getDebugTSL() {
        return this.debugTSL;
    }

    public void setDebugTSL(String string) {
        this.debugTSL = string;
    }

    public boolean isAtrListsUpdated() {
        if (this.g == null || this.f == null) {
            return false;
        }
        List<AtrDbItem> list = this.cdb.getAtrWhiteList();
        List<AtrDbItem> list2 = this.cdb.getAtrBlackList();
        if (list.size() != this.g.size() || list2.size() != this.f.size()) {
            return true;
        }
        for (CaTokensElement caTokensElement : this.f) {
            if (RootUpdater.checkAtrLists(list2, caTokensElement.getAtx())) continue;
            return true;
        }
        for (CaTokensElement caTokensElement : this.g) {
            if (RootUpdater.checkAtrLists(list, caTokensElement.getAtx())) continue;
            return true;
        }
        return false;
    }

    public void downloadAtrLists() {
        UrlClient urlClient = new UrlClient(this.networkConfig, logger);
        urlClient = new RestClient(urlClient, null, false, logger);
        this.g = new ArrayList<CaTokensElement>();
        if (!this.a((RestClient)urlClient, this.g, "WL", 0)) {
            this.g = null;
        }
        this.f = new ArrayList<CaTokensElement>();
        if (!this.a((RestClient)urlClient, this.f, "BL", 0)) {
            this.f = null;
        }
    }

    public static boolean checkAtrLists(List<AtrDbItem> object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            AtrDbItem atrDbItem = (AtrDbItem)object.next();
            if (!atrDbItem.getAtr().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean a(RestClient restClient, List<CaTokensElement> list, String string, int n) {
        try {
            RestClientRequest restClientRequest = new RestClientRequest();
            restClientRequest.setMethod("GET");
            Object object = (RestResponse)restClient.sendRequest(System.getProperty("capi.certdb.customurl.atrlist", "https://cafrontend.aruba.it/entws/api/tokens") + "?listType=" + string + "&pageNumber=" + n, (HttpRequest)restClientRequest, new URLCredentials(null, this.d, this.e));
            if (object.getStatus().equals("OK")) {
                restClientRequest = new ObjectMapper();
                restClientRequest = restClientRequest.readerFor(CaTokensResponse.class);
                object = (CaTokensResponse)restClientRequest.readValue(object.getResponseData());
                list.addAll(((CaTokensResponse)object).getElements());
                if (((CaTokensResponse)object).getTotalPages() > 1 && ((CaTokensResponse)object).getNextPage() != -1) {
                    return this.a(restClient, list, string, ((CaTokensResponse)object).getNextPage());
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public void updateATR() throws CapiException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.f != null) {
            for (CaTokensElement caTokensElement : this.f) {
                arrayList.add(caTokensElement.getAtx());
            }
            this.cdb.replaceAtrBlacklist(arrayList);
        }
        if (this.g != null) {
            for (CaTokensElement caTokensElement : this.g) {
                arrayList2.add(caTokensElement.getAtx());
            }
            this.cdb.replaceAtrWhitelist(arrayList2);
        }
    }
}

